/*
 Persistence of Vision Ray Tracer Object Description File
 Filename    : v8 wheel.inc
 Version     : 3
 Author      : Panagiotis Vossos
 E-mail      : pvossos@otenet.gr
 Date        : 26/02/98

 As long as you make NO money using any of this stuff here,you can
 do whatever you want with it.All I am asking is to let me know.
 If you want to use this stuff in a commercial way , then you should
 contact me FIRST.Thanks.
*/

#declare CSG666 = union {
  cylinder { // LEPTOS KILINDROS KENTROU
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 0.05>
    rotate -90.0*x
    translate  -0.025*y
  }
  cylinder { // PAXIS KILINDROS KENTROU
    <0,0,1>, <0,0,0>, 1
    scale <0.28, 0.28, 0.15>
    rotate -90.0*x
    translate  -0.075*y
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.1, 0.1, 0.448184>
    rotate -90.0*x
    translate  -0.38*y
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.07, 0.07, 0.43>
    rotate -90.0*x
    translate  <0.4, -0.48, 0.0>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.07, 0.07, 0.41>
    rotate -90.0*x
    translate  <0.600624, -0.49, 1.34>
  }
}

#declare tripa = cylinder {
                 <0,0,1>, <0,0,0>, 1
                 scale <0.05, 0.05, 0.2>
                 rotate -90.0*x
                 translate  <0.0, -0.1,0 >
                 }
#declare Kentro = difference { // KENTRO TROXOU
  object { CSG666 }
#declare Count = 0
  #while ( Count < 8 )
   object { tripa translate 0.18*<cos(pi*Count/4),0,sin(pi*Count/4)>}
   #declare Count = Count + 1
  #end
  texture { T_ZantesStuff }
          }


#declare aktines4 = union { // Mia Tetrada Aktinon Ston Troxo
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.006, 0.006, 0.75>
    rotate <-6.6, 43.810001, 0.05>
    translate  <-0.57, -0.103, -0.86>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.006, 0.006, 0.75>
    rotate <6.6, 43.810001, 0.05>
    translate  <-0.57, 0.103, -0.86>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.006, 0.006, 0.75>
    rotate <-6.6, -43.810001, 0.05>
    translate  <0.57, -0.103, -0.86>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.006, 0.006, 0.75>
    rotate <6.6, -43.810001, 0.05>
    translate  <0.57, 0.103, -0.86>
  }
}

#declare Aktines = union {
#declare Count = 0
  #while ( Count < 360 )
   object { aktines4 rotate <0,Count,0> }
   #declare Count = Count + 30
  #end
  texture { T_Aktines }
  }


#declare Wheel_Pelma = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.4652, -0.0028, 0.0000> <1.4652, -0.0789, 0.0000> <1.4004, -0.1839, 0.0000> <1.3330, -0.2195, 0.0000>
		<1.4652, -0.0028, -0.2275> <1.4652, -0.0789, -0.2275> <1.4004, -0.1839, -0.2070> <1.3330, -0.2195, -0.2070>
		<1.3827, -0.0028, -0.5356> <1.3827, -0.0789, -0.5356> <1.3162, -0.1839, -0.5209> <1.2579, -0.2195, -0.4872>
		<1.2689, -0.0028, -0.7326> <1.2689, -0.0789, -0.7326> <1.2127, -0.1839, -0.7002> <1.1544, -0.2195, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.4652, -0.0028, 0.0000> <1.4652, -0.0028, 0.2275> <1.3827, -0.0028, 0.5356> <1.2689, -0.0028, 0.7326>
		<1.4652, -0.0789, 0.0000> <1.4652, -0.0789, 0.2275> <1.3827, -0.0789, 0.5356> <1.2689, -0.0789, 0.7326>
		<1.4004, -0.1839, 0.0000> <1.4004, -0.1839, 0.2070> <1.3162, -0.1839, 0.5209> <1.2127, -0.1839, 0.7002>
		<1.3330, -0.2195, 0.0000> <1.3330, -0.2195, 0.2070> <1.2579, -0.2195, 0.4872> <1.1544, -0.2195, 0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.4652, -0.0028, 0.0000> <1.4652, -0.0028, -0.2275> <1.3827, -0.0028, -0.5356> <1.2689, -0.0028, -0.7326>
		<1.4652, 0.0734, 0.0000> <1.4652, 0.0734, -0.2275> <1.3827, 0.0734, -0.5356> <1.2689, 0.0734, -0.7326>
		<1.4004, 0.1784, 0.0000> <1.4004, 0.1784, -0.2070> <1.3162, 0.1784, -0.5209> <1.2127, 0.1784, -0.7002>
		<1.3330, 0.2140, 0.0000> <1.3330, 0.2140, -0.2070> <1.2579, 0.2140, -0.4872> <1.1544, 0.2140, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.4652, -0.0028, 0.0000> <1.4652, 0.0734, 0.0000> <1.4004, 0.1784, 0.0000> <1.3330, 0.2140, 0.0000>
		<1.4652, -0.0028, 0.2275> <1.4652, 0.0734, 0.2275> <1.4004, 0.1784, 0.2070> <1.3330, 0.2140, 0.2070>
		<1.3827, -0.0028, 0.5356> <1.3827, 0.0734, 0.5356> <1.3162, 0.1784, 0.5209> <1.2579, 0.2140, 0.4872>
		<1.2689, -0.0028, 0.7326> <1.2689, 0.0734, 0.7326> <1.2127, 0.1784, 0.7002> <1.1544, 0.2140, 0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3330, -0.2195, 0.0000> <1.2688, -0.2535, 0.0000> <1.1078, -0.2152, 0.0000> <1.0915, -0.2003, 0.0000>
		<1.3330, -0.2195, -0.2070> <1.2688, -0.2535, -0.2070> <1.1078, -0.2152, -0.1695> <1.0915, -0.2003, -0.1695>
		<1.2579, -0.2195, -0.4872> <1.2023, -0.2535, -0.4551> <1.0442, -0.2152, -0.4071> <1.0300, -0.2003, -0.3990>
		<1.1544, -0.2195, -0.6665> <1.0988, -0.2535, -0.6344> <0.9594, -0.2152, -0.5539> <0.9453, -0.2003, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3330, -0.2195, 0.0000> <1.3330, -0.2195, 0.2070> <1.2579, -0.2195, 0.4872> <1.1544, -0.2195, 0.6665>
		<1.2688, -0.2535, 0.0000> <1.2688, -0.2535, 0.2070> <1.2023, -0.2535, 0.4551> <1.0988, -0.2535, 0.6344>
		<1.1078, -0.2152, 0.0000> <1.1078, -0.2152, 0.1695> <1.0442, -0.2152, 0.4071> <0.9594, -0.2152, 0.5539>
		<1.0915, -0.2003, 0.0000> <1.0915, -0.2003, 0.1695> <1.0300, -0.2003, 0.3990> <0.9453, -0.2003, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3330, 0.2140, 0.0000> <1.3330, 0.2140, -0.2070> <1.2579, 0.2140, -0.4872> <1.1544, 0.2140, -0.6665>
		<1.2688, 0.2479, 0.0000> <1.2688, 0.2479, -0.2070> <1.2023, 0.2479, -0.4551> <1.0988, 0.2479, -0.6344>
		<1.1093, 0.2099, 0.0000> <1.1093, 0.2099, -0.1695> <1.0454, 0.2099, -0.4079> <0.9607, 0.2099, -0.5547>
		<1.0915, 0.1947, 0.0000> <1.0915, 0.1947, -0.1695> <1.0300, 0.1947, -0.3990> <0.9453, 0.1947, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3330, 0.2140, 0.0000> <1.2688, 0.2479, 0.0000> <1.1093, 0.2099, 0.0000> <1.0915, 0.1947, 0.0000>
		<1.3330, 0.2140, 0.2070> <1.2688, 0.2479, 0.2070> <1.1093, 0.2099, 0.1695> <1.0915, 0.1947, 0.1695>
		<1.2579, 0.2140, 0.4872> <1.2023, 0.2479, 0.4551> <1.0454, 0.2099, 0.4079> <1.0300, 0.1947, 0.3990>
		<1.1544, 0.2140, 0.6665> <1.0988, 0.2479, 0.6344> <0.9607, 0.2099, 0.5547> <0.9453, 0.1947, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0915, 0.1947, 0.0000> <1.0915, 0.1947, -0.1695> <1.0300, 0.1947, -0.3990> <0.9453, 0.1947, -0.5457>
		<1.0775, 0.1829, 0.0000> <1.0775, 0.1829, -0.1695> <1.0179, 0.1829, -0.3920> <0.9332, 0.1829, -0.5388>
		<1.0873, -0.0336, 0.0000> <1.0873, -0.0336, -0.1688> <1.0260, -0.0336, -0.3974> <0.9416, -0.0336, -0.5436>
		<1.0873, 0.0052, 0.0000> <1.0873, 0.0052, -0.1688> <1.0260, 0.0052, -0.3974> <0.9416, 0.0052, -0.5436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0915, 0.1947, 0.0000> <1.0775, 0.1829, 0.0000> <1.0873, -0.0336, 0.0000> <1.0873, 0.0052, 0.0000>
		<1.0915, 0.1947, 0.1695> <1.0775, 0.1829, 0.1695> <1.0873, -0.0336, 0.1688> <1.0873, 0.0052, 0.1688>
		<1.0300, 0.1947, 0.3990> <1.0179, 0.1829, 0.3920> <1.0260, -0.0336, 0.3974> <1.0260, 0.0052, 0.3974>
		<0.9453, 0.1947, 0.5457> <0.9332, 0.1829, 0.5388> <0.9416, -0.0336, 0.5436> <0.9416, 0.0052, 0.5436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0873, 0.0052, 0.0000> <1.0873, 0.0052, -0.1688> <1.0260, 0.0052, -0.3974> <0.9416, 0.0052, -0.5436>
		<1.0873, 0.0474, 0.0000> <1.0873, 0.0474, -0.1688> <1.0260, 0.0474, -0.3974> <0.9416, 0.0474, -0.5436>
		<1.0776, -0.1876, 0.0000> <1.0776, -0.1876, -0.1695> <1.0180, -0.1876, -0.3920> <0.9332, -0.1876, -0.5388>
		<1.0915, -0.2003, 0.0000> <1.0915, -0.2003, -0.1695> <1.0300, -0.2003, -0.3990> <0.9453, -0.2003, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0873, 0.0052, 0.0000> <1.0873, 0.0474, 0.0000> <1.0776, -0.1876, 0.0000> <1.0915, -0.2003, 0.0000>
		<1.0873, 0.0052, 0.1688> <1.0873, 0.0474, 0.1688> <1.0776, -0.1876, 0.1695> <1.0915, -0.2003, 0.1695>
		<1.0260, 0.0052, 0.3974> <1.0260, 0.0474, 0.3974> <1.0180, -0.1876, 0.3920> <1.0300, -0.2003, 0.3990>
		<0.9416, 0.0052, 0.5436> <0.9416, 0.0474, 0.5436> <0.9332, -0.1876, 0.5388> <0.9453, -0.2003, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.9416, 0.0052, 0.5436> <0.8572, 0.0052, 0.6899> <0.6899, 0.0052, 0.8572> <0.5436, 0.0052, 0.9416>
		<0.9416, -0.0336, 0.5436> <0.8572, -0.0336, 0.6899> <0.6899, -0.0336, 0.8572> <0.5436, -0.0336, 0.9416>
		<0.9332, 0.1829, 0.5388> <0.8484, 0.1829, 0.6856> <0.6856, 0.1829, 0.8484> <0.5388, 0.1829, 0.9332>
		<0.9453, 0.1947, 0.5457> <0.8605, 0.1947, 0.6925> <0.6925, 0.1947, 0.8605> <0.5457, 0.1947, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.9416, 0.0052, 0.5436> <0.9416, 0.0474, 0.5436> <0.9332, -0.1876, 0.5388> <0.9453, -0.2003, 0.5457>
		<0.8572, 0.0052, 0.6899> <0.8572, 0.0474, 0.6899> <0.8485, -0.1876, 0.6856> <0.8605, -0.2003, 0.6925>
		<0.6899, 0.0052, 0.8572> <0.6899, 0.0474, 0.8572> <0.6856, -0.1876, 0.8485> <0.6925, -0.2003, 0.8605>
		<0.5436, 0.0052, 0.9416> <0.5436, 0.0474, 0.9416> <0.5388, -0.1876, 0.9332> <0.5457, -0.2003, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5436, 0.0052, 0.9416> <0.3974, 0.0052, 1.0260> <0.1688, 0.0052, 1.0873> <-0.0000, 0.0052, 1.0873>
		<0.5436, -0.0336, 0.9416> <0.3974, -0.0336, 1.0260> <0.1688, -0.0336, 1.0873> <-0.0000, -0.0336, 1.0873>
		<0.5388, 0.1829, 0.9332> <0.3920, 0.1829, 1.0179> <0.1695, 0.1829, 1.0775> <-0.0000, 0.1829, 1.0775>
		<0.5457, 0.1947, 0.9453> <0.3990, 0.1947, 1.0300> <0.1695, 0.1947, 1.0915> <-0.0000, 0.1947, 1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5436, 0.0052, 0.9416> <0.5436, 0.0474, 0.9416> <0.5388, -0.1876, 0.9332> <0.5457, -0.2003, 0.9453>
		<0.3974, 0.0052, 1.0260> <0.3974, 0.0474, 1.0260> <0.3920, -0.1876, 1.0180> <0.3990, -0.2003, 1.0300>
		<0.1688, 0.0052, 1.0873> <0.1688, 0.0474, 1.0873> <0.1695, -0.1876, 1.0776> <0.1695, -0.2003, 1.0915>
		<-0.0000, 0.0052, 1.0873> <-0.0000, 0.0474, 1.0873> <-0.0000, -0.1876, 1.0776> <-0.0000, -0.2003, 1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, 0.0052, 1.0873> <-0.1688, 0.0052, 1.0873> <-0.3974, 0.0052, 1.0260> <-0.5436, 0.0052, 0.9416>
		<-0.0000, -0.0336, 1.0873> <-0.1688, -0.0336, 1.0873> <-0.3974, -0.0336, 1.0260> <-0.5436, -0.0336, 0.9416>
		<-0.0000, 0.1829, 1.0775> <-0.1695, 0.1829, 1.0775> <-0.3920, 0.1829, 1.0179> <-0.5388, 0.1829, 0.9332>
		<-0.0000, 0.1947, 1.0915> <-0.1695, 0.1947, 1.0915> <-0.3990, 0.1947, 1.0300> <-0.5457, 0.1947, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, 0.0052, 1.0873> <-0.0000, 0.0474, 1.0873> <-0.0000, -0.1876, 1.0776> <-0.0000, -0.2003, 1.0915>
		<-0.1688, 0.0052, 1.0873> <-0.1688, 0.0474, 1.0873> <-0.1695, -0.1876, 1.0776> <-0.1695, -0.2003, 1.0915>
		<-0.3974, 0.0052, 1.0260> <-0.3974, 0.0474, 1.0260> <-0.3920, -0.1876, 1.0180> <-0.3990, -0.2003, 1.0300>
		<-0.5436, 0.0052, 0.9416> <-0.5436, 0.0474, 0.9416> <-0.5388, -0.1876, 0.9332> <-0.5457, -0.2003, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5436, 0.0052, 0.9416> <-0.6899, 0.0052, 0.8572> <-0.8572, 0.0052, 0.6899> <-0.9416, 0.0052, 0.5436>
		<-0.5436, -0.0336, 0.9416> <-0.6899, -0.0336, 0.8572> <-0.8572, -0.0336, 0.6899> <-0.9416, -0.0336, 0.5436>
		<-0.5388, 0.1829, 0.9332> <-0.6856, 0.1829, 0.8484> <-0.8484, 0.1829, 0.6856> <-0.9332, 0.1829, 0.5388>
		<-0.5457, 0.1947, 0.9453> <-0.6925, 0.1947, 0.8605> <-0.8605, 0.1947, 0.6925> <-0.9453, 0.1947, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5436, 0.0052, 0.9416> <-0.5436, 0.0474, 0.9416> <-0.5388, -0.1876, 0.9332> <-0.5457, -0.2003, 0.9453>
		<-0.6899, 0.0052, 0.8572> <-0.6899, 0.0474, 0.8572> <-0.6856, -0.1876, 0.8485> <-0.6925, -0.2003, 0.8605>
		<-0.8572, 0.0052, 0.6899> <-0.8572, 0.0474, 0.6899> <-0.8485, -0.1876, 0.6856> <-0.8605, -0.2003, 0.6925>
		<-0.9416, 0.0052, 0.5436> <-0.9416, 0.0474, 0.5436> <-0.9332, -0.1876, 0.5388> <-0.9453, -0.2003, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9416, 0.0052, 0.5436> <-1.0260, 0.0052, 0.3974> <-1.0873, 0.0052, 0.1688> <-1.0873, 0.0052, -0.0000>
		<-0.9416, -0.0336, 0.5436> <-1.0260, -0.0336, 0.3974> <-1.0873, -0.0336, 0.1688> <-1.0873, -0.0336, -0.0000>
		<-0.9332, 0.1829, 0.5388> <-1.0179, 0.1829, 0.3920> <-1.0775, 0.1829, 0.1695> <-1.0775, 0.1829, -0.0000>
		<-0.9453, 0.1947, 0.5457> <-1.0300, 0.1947, 0.3990> <-1.0915, 0.1947, 0.1695> <-1.0915, 0.1947, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9416, 0.0052, 0.5436> <-0.9416, 0.0474, 0.5436> <-0.9332, -0.1876, 0.5388> <-0.9453, -0.2003, 0.5457>
		<-1.0260, 0.0052, 0.3974> <-1.0260, 0.0474, 0.3974> <-1.0180, -0.1876, 0.3920> <-1.0300, -0.2003, 0.3990>
		<-1.0873, 0.0052, 0.1688> <-1.0873, 0.0474, 0.1688> <-1.0776, -0.1876, 0.1695> <-1.0915, -0.2003, 0.1695>
		<-1.0873, 0.0052, -0.0000> <-1.0873, 0.0474, -0.0000> <-1.0776, -0.1876, -0.0000> <-1.0915, -0.2003, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0873, 0.0052, -0.0000> <-1.0873, 0.0052, -0.1688> <-1.0260, 0.0052, -0.3974> <-0.9416, 0.0052, -0.5436>
		<-1.0873, -0.0336, -0.0000> <-1.0873, -0.0336, -0.1688> <-1.0260, -0.0336, -0.3974> <-0.9416, -0.0336, -0.5436>
		<-1.0775, 0.1829, -0.0000> <-1.0775, 0.1829, -0.1695> <-1.0179, 0.1829, -0.3920> <-0.9332, 0.1829, -0.5388>
		<-1.0915, 0.1947, -0.0000> <-1.0915, 0.1947, -0.1695> <-1.0300, 0.1947, -0.3990> <-0.9453, 0.1947, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0873, 0.0052, -0.0000> <-1.0873, 0.0474, -0.0000> <-1.0776, -0.1876, -0.0000> <-1.0915, -0.2003, -0.0000>
		<-1.0873, 0.0052, -0.1688> <-1.0873, 0.0474, -0.1688> <-1.0776, -0.1876, -0.1695> <-1.0915, -0.2003, -0.1695>
		<-1.0260, 0.0052, -0.3974> <-1.0260, 0.0474, -0.3974> <-1.0180, -0.1876, -0.3920> <-1.0300, -0.2003, -0.3990>
		<-0.9416, 0.0052, -0.5436> <-0.9416, 0.0474, -0.5436> <-0.9332, -0.1876, -0.5388> <-0.9453, -0.2003, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9416, 0.0052, -0.5436> <-0.8572, 0.0052, -0.6899> <-0.6899, 0.0052, -0.8572> <-0.5436, 0.0052, -0.9416>
		<-0.9416, -0.0336, -0.5436> <-0.8572, -0.0336, -0.6899> <-0.6899, -0.0336, -0.8572> <-0.5436, -0.0336, -0.9416>
		<-0.9332, 0.1829, -0.5388> <-0.8484, 0.1829, -0.6856> <-0.6856, 0.1829, -0.8484> <-0.5388, 0.1829, -0.9332>
		<-0.9453, 0.1947, -0.5457> <-0.8605, 0.1947, -0.6925> <-0.6925, 0.1947, -0.8605> <-0.5457, 0.1947, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9416, 0.0052, -0.5436> <-0.9416, 0.0474, -0.5436> <-0.9332, -0.1876, -0.5388> <-0.9453, -0.2003, -0.5457>
		<-0.8572, 0.0052, -0.6899> <-0.8572, 0.0474, -0.6899> <-0.8485, -0.1876, -0.6856> <-0.8605, -0.2003, -0.6925>
		<-0.6899, 0.0052, -0.8572> <-0.6899, 0.0474, -0.8572> <-0.6856, -0.1876, -0.8485> <-0.6925, -0.2003, -0.8605>
		<-0.5436, 0.0052, -0.9416> <-0.5436, 0.0474, -0.9416> <-0.5388, -0.1876, -0.9332> <-0.5457, -0.2003, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5436, 0.0052, -0.9416> <-0.3974, 0.0052, -1.0260> <-0.1688, 0.0052, -1.0873> <0.0000, 0.0052, -1.0873>
		<-0.5436, -0.0336, -0.9416> <-0.3974, -0.0336, -1.0260> <-0.1688, -0.0336, -1.0873> <0.0000, -0.0336, -1.0873>
		<-0.5388, 0.1829, -0.9332> <-0.3920, 0.1829, -1.0179> <-0.1695, 0.1829, -1.0775> <0.0000, 0.1829, -1.0775>
		<-0.5457, 0.1947, -0.9453> <-0.3990, 0.1947, -1.0300> <-0.1695, 0.1947, -1.0915> <0.0000, 0.1947, -1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5436, 0.0052, -0.9416> <-0.5436, 0.0474, -0.9416> <-0.5388, -0.1876, -0.9332> <-0.5457, -0.2003, -0.9453>
		<-0.3974, 0.0052, -1.0260> <-0.3974, 0.0474, -1.0260> <-0.3920, -0.1876, -1.0180> <-0.3990, -0.2003, -1.0300>
		<-0.1688, 0.0052, -1.0873> <-0.1688, 0.0474, -1.0873> <-0.1695, -0.1876, -1.0776> <-0.1695, -0.2003, -1.0915>
		<0.0000, 0.0052, -1.0873> <0.0000, 0.0474, -1.0873> <0.0000, -0.1876, -1.0776> <0.0000, -0.2003, -1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0052, -1.0873> <0.1688, 0.0052, -1.0873> <0.3974, 0.0052, -1.0260> <0.5436, 0.0052, -0.9416>
		<0.0000, -0.0336, -1.0873> <0.1688, -0.0336, -1.0873> <0.3974, -0.0336, -1.0260> <0.5436, -0.0336, -0.9416>
		<0.0000, 0.1829, -1.0775> <0.1695, 0.1829, -1.0775> <0.3920, 0.1829, -1.0179> <0.5388, 0.1829, -0.9332>
		<0.0000, 0.1947, -1.0915> <0.1695, 0.1947, -1.0915> <0.3990, 0.1947, -1.0300> <0.5457, 0.1947, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0052, -1.0873> <0.0000, 0.0474, -1.0873> <0.0000, -0.1876, -1.0776> <0.0000, -0.2003, -1.0915>
		<0.1688, 0.0052, -1.0873> <0.1688, 0.0474, -1.0873> <0.1695, -0.1876, -1.0776> <0.1695, -0.2003, -1.0915>
		<0.3974, 0.0052, -1.0260> <0.3974, 0.0474, -1.0260> <0.3920, -0.1876, -1.0180> <0.3990, -0.2003, -1.0300>
		<0.5436, 0.0052, -0.9416> <0.5436, 0.0474, -0.9416> <0.5388, -0.1876, -0.9332> <0.5457, -0.2003, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5436, 0.0052, -0.9416> <0.6899, 0.0052, -0.8572> <0.8572, 0.0052, -0.6899> <0.9416, 0.0052, -0.5436>
		<0.5436, -0.0336, -0.9416> <0.6899, -0.0336, -0.8572> <0.8572, -0.0336, -0.6899> <0.9416, -0.0336, -0.5436>
		<0.5388, 0.1829, -0.9332> <0.6856, 0.1829, -0.8484> <0.8484, 0.1829, -0.6856> <0.9332, 0.1829, -0.5388>
		<0.5457, 0.1947, -0.9453> <0.6925, 0.1947, -0.8605> <0.8605, 0.1947, -0.6925> <0.9453, 0.1947, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5436, 0.0052, -0.9416> <0.5436, 0.0474, -0.9416> <0.5388, -0.1876, -0.9332> <0.5457, -0.2003, -0.9453>
		<0.6899, 0.0052, -0.8572> <0.6899, 0.0474, -0.8572> <0.6856, -0.1876, -0.8485> <0.6925, -0.2003, -0.8605>
		<0.8572, 0.0052, -0.6899> <0.8572, 0.0474, -0.6899> <0.8485, -0.1876, -0.6856> <0.8605, -0.2003, -0.6925>
		<0.9416, 0.0052, -0.5436> <0.9416, 0.0474, -0.5436> <0.9332, -0.1876, -0.5388> <0.9453, -0.2003, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.9453, -0.2003, 0.5457> <0.9594, -0.2152, 0.5539> <1.0988, -0.2535, 0.6344> <1.1544, -0.2195, 0.6665>
		<0.8605, -0.2003, 0.6925> <0.8747, -0.2152, 0.7007> <0.9953, -0.2535, 0.8136> <1.0509, -0.2195, 0.8458>
		<0.6925, -0.2003, 0.8605> <0.7007, -0.2152, 0.8747> <0.8136, -0.2535, 0.9953> <0.8458, -0.2195, 1.0509>
		<0.5457, -0.2003, 0.9453> <0.5539, -0.2152, 0.9594> <0.6344, -0.2535, 1.0988> <0.6665, -0.2195, 1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5457, -0.2003, 0.9453> <0.5539, -0.2152, 0.9594> <0.6344, -0.2535, 1.0988> <0.6665, -0.2195, 1.1544>
		<0.3990, -0.2003, 1.0300> <0.4071, -0.2152, 1.0442> <0.4551, -0.2535, 1.2023> <0.4872, -0.2195, 1.2579>
		<0.1695, -0.2003, 1.0915> <0.1695, -0.2152, 1.1078> <0.2070, -0.2535, 1.2688> <0.2070, -0.2195, 1.3330>
		<-0.0000, -0.2003, 1.0915> <-0.0000, -0.2152, 1.1078> <-0.0000, -0.2535, 1.2688> <-0.0000, -0.2195, 1.3330>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, -0.2003, 1.0915> <-0.0000, -0.2152, 1.1078> <-0.0000, -0.2535, 1.2688> <-0.0000, -0.2195, 1.3330>
		<-0.1695, -0.2003, 1.0915> <-0.1695, -0.2152, 1.1078> <-0.2070, -0.2535, 1.2688> <-0.2070, -0.2195, 1.3330>
		<-0.3990, -0.2003, 1.0300> <-0.4071, -0.2152, 1.0442> <-0.4551, -0.2535, 1.2023> <-0.4872, -0.2195, 1.2579>
		<-0.5457, -0.2003, 0.9453> <-0.5539, -0.2152, 0.9594> <-0.6344, -0.2535, 1.0988> <-0.6665, -0.2195, 1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5457, -0.2003, 0.9453> <-0.5539, -0.2152, 0.9594> <-0.6344, -0.2535, 1.0988> <-0.6665, -0.2195, 1.1544>
		<-0.6925, -0.2003, 0.8605> <-0.7007, -0.2152, 0.8747> <-0.8136, -0.2535, 0.9953> <-0.8458, -0.2195, 1.0509>
		<-0.8605, -0.2003, 0.6925> <-0.8747, -0.2152, 0.7007> <-0.9953, -0.2535, 0.8136> <-1.0509, -0.2195, 0.8458>
		<-0.9453, -0.2003, 0.5457> <-0.9594, -0.2152, 0.5539> <-1.0988, -0.2535, 0.6344> <-1.1544, -0.2195, 0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9453, -0.2003, 0.5457> <-0.9594, -0.2152, 0.5539> <-1.0988, -0.2535, 0.6344> <-1.1544, -0.2195, 0.6665>
		<-1.0300, -0.2003, 0.3990> <-1.0442, -0.2152, 0.4071> <-1.2023, -0.2535, 0.4551> <-1.2579, -0.2195, 0.4872>
		<-1.0915, -0.2003, 0.1695> <-1.1078, -0.2152, 0.1695> <-1.2688, -0.2535, 0.2070> <-1.3330, -0.2195, 0.2070>
		<-1.0915, -0.2003, -0.0000> <-1.1078, -0.2152, -0.0000> <-1.2688, -0.2535, -0.0000> <-1.3330, -0.2195, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0915, -0.2003, -0.0000> <-1.1078, -0.2152, -0.0000> <-1.2688, -0.2535, -0.0000> <-1.3330, -0.2195, -0.0000>
		<-1.0915, -0.2003, -0.1695> <-1.1078, -0.2152, -0.1695> <-1.2688, -0.2535, -0.2070> <-1.3330, -0.2195, -0.2070>
		<-1.0300, -0.2003, -0.3990> <-1.0442, -0.2152, -0.4071> <-1.2023, -0.2535, -0.4551> <-1.2579, -0.2195, -0.4872>
		<-0.9453, -0.2003, -0.5457> <-0.9594, -0.2152, -0.5539> <-1.0988, -0.2535, -0.6344> <-1.1544, -0.2195, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9453, -0.2003, -0.5457> <-0.9594, -0.2152, -0.5539> <-1.0988, -0.2535, -0.6344> <-1.1544, -0.2195, -0.6665>
		<-0.8605, -0.2003, -0.6925> <-0.8747, -0.2152, -0.7007> <-0.9953, -0.2535, -0.8136> <-1.0509, -0.2195, -0.8458>
		<-0.6925, -0.2003, -0.8605> <-0.7007, -0.2152, -0.8747> <-0.8136, -0.2535, -0.9953> <-0.8458, -0.2195, -1.0509>
		<-0.5457, -0.2003, -0.9453> <-0.5539, -0.2152, -0.9594> <-0.6344, -0.2535, -1.0988> <-0.6665, -0.2195, -1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5457, -0.2003, -0.9453> <-0.5539, -0.2152, -0.9594> <-0.6344, -0.2535, -1.0988> <-0.6665, -0.2195, -1.1544>
		<-0.3990, -0.2003, -1.0300> <-0.4071, -0.2152, -1.0442> <-0.4551, -0.2535, -1.2023> <-0.4872, -0.2195, -1.2579>
		<-0.1695, -0.2003, -1.0915> <-0.1695, -0.2152, -1.1078> <-0.2070, -0.2535, -1.2688> <-0.2070, -0.2195, -1.3330>
		<0.0000, -0.2003, -1.0915> <0.0000, -0.2152, -1.1078> <0.0000, -0.2535, -1.2688> <0.0000, -0.2195, -1.3330>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2003, -1.0915> <0.0000, -0.2152, -1.1078> <0.0000, -0.2535, -1.2688> <0.0000, -0.2195, -1.3330>
		<0.1695, -0.2003, -1.0915> <0.1695, -0.2152, -1.1078> <0.2070, -0.2535, -1.2688> <0.2070, -0.2195, -1.3330>
		<0.3990, -0.2003, -1.0300> <0.4071, -0.2152, -1.0442> <0.4551, -0.2535, -1.2023> <0.4872, -0.2195, -1.2579>
		<0.5457, -0.2003, -0.9453> <0.5539, -0.2152, -0.9594> <0.6344, -0.2535, -1.0988> <0.6665, -0.2195, -1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5457, -0.2003, -0.9453> <0.5539, -0.2152, -0.9594> <0.6344, -0.2535, -1.0988> <0.6665, -0.2195, -1.1544>
		<0.6925, -0.2003, -0.8605> <0.7007, -0.2152, -0.8747> <0.8136, -0.2535, -0.9953> <0.8458, -0.2195, -1.0509>
		<0.8605, -0.2003, -0.6925> <0.8747, -0.2152, -0.7007> <0.9953, -0.2535, -0.8136> <1.0509, -0.2195, -0.8458>
		<0.9453, -0.2003, -0.5457> <0.9594, -0.2152, -0.5539> <1.0988, -0.2535, -0.6344> <1.1544, -0.2195, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1544, -0.2195, 0.6665> <1.2127, -0.1839, 0.7002> <1.2689, -0.0789, 0.7326> <1.2689, -0.0028, 0.7326>
		<1.0509, -0.2195, 0.8458> <1.1092, -0.1839, 0.8795> <1.1551, -0.0789, 0.9297> <1.1551, -0.0028, 0.9297>
		<0.8458, -0.2195, 1.0509> <0.8795, -0.1839, 1.1092> <0.9297, -0.0789, 1.1551> <0.9297, -0.0028, 1.1551>
		<0.6665, -0.2195, 1.1544> <0.7002, -0.1839, 1.2127> <0.7326, -0.0789, 1.2689> <0.7326, -0.0028, 1.2689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6665, -0.2195, 1.1544> <0.7002, -0.1839, 1.2127> <0.7326, -0.0789, 1.2689> <0.7326, -0.0028, 1.2689>
		<0.4872, -0.2195, 1.2579> <0.5209, -0.1839, 1.3162> <0.5356, -0.0789, 1.3827> <0.5356, -0.0028, 1.3827>
		<0.2070, -0.2195, 1.3330> <0.2070, -0.1839, 1.4004> <0.2275, -0.0789, 1.4652> <0.2275, -0.0028, 1.4652>
		<-0.0000, -0.2195, 1.3330> <-0.0000, -0.1839, 1.4004> <-0.0000, -0.0789, 1.4652> <-0.0000, -0.0028, 1.4652>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, -0.2195, 1.3330> <-0.0000, -0.1839, 1.4004> <-0.0000, -0.0789, 1.4652> <-0.0000, -0.0028, 1.4652>
		<-0.2070, -0.2195, 1.3330> <-0.2070, -0.1839, 1.4004> <-0.2275, -0.0789, 1.4652> <-0.2275, -0.0028, 1.4652>
		<-0.4872, -0.2195, 1.2579> <-0.5209, -0.1839, 1.3162> <-0.5356, -0.0789, 1.3827> <-0.5356, -0.0028, 1.3827>
		<-0.6665, -0.2195, 1.1544> <-0.7002, -0.1839, 1.2127> <-0.7326, -0.0789, 1.2689> <-0.7326, -0.0028, 1.2689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6665, -0.2195, 1.1544> <-0.7002, -0.1839, 1.2127> <-0.7326, -0.0789, 1.2689> <-0.7326, -0.0028, 1.2689>
		<-0.8458, -0.2195, 1.0509> <-0.8795, -0.1839, 1.1092> <-0.9297, -0.0789, 1.1551> <-0.9297, -0.0028, 1.1551>
		<-1.0509, -0.2195, 0.8458> <-1.1092, -0.1839, 0.8795> <-1.1551, -0.0789, 0.9297> <-1.1551, -0.0028, 0.9297>
		<-1.1544, -0.2195, 0.6665> <-1.2127, -0.1839, 0.7002> <-1.2689, -0.0789, 0.7326> <-1.2689, -0.0028, 0.7326>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1544, -0.2195, 0.6665> <-1.2127, -0.1839, 0.7002> <-1.2689, -0.0789, 0.7326> <-1.2689, -0.0028, 0.7326>
		<-1.2579, -0.2195, 0.4872> <-1.3162, -0.1839, 0.5209> <-1.3827, -0.0789, 0.5356> <-1.3827, -0.0028, 0.5356>
		<-1.3330, -0.2195, 0.2070> <-1.4004, -0.1839, 0.2070> <-1.4652, -0.0789, 0.2275> <-1.4652, -0.0028, 0.2275>
		<-1.3330, -0.2195, -0.0000> <-1.4004, -0.1839, -0.0000> <-1.4652, -0.0789, -0.0000> <-1.4652, -0.0028, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3330, -0.2195, -0.0000> <-1.4004, -0.1839, -0.0000> <-1.4652, -0.0789, -0.0000> <-1.4652, -0.0028, -0.0000>
		<-1.3330, -0.2195, -0.2070> <-1.4004, -0.1839, -0.2070> <-1.4652, -0.0789, -0.2275> <-1.4652, -0.0028, -0.2275>
		<-1.2579, -0.2195, -0.4872> <-1.3162, -0.1839, -0.5209> <-1.3827, -0.0789, -0.5356> <-1.3827, -0.0028, -0.5356>
		<-1.1544, -0.2195, -0.6665> <-1.2127, -0.1839, -0.7002> <-1.2689, -0.0789, -0.7326> <-1.2689, -0.0028, -0.7326>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1544, -0.2195, -0.6665> <-1.2127, -0.1839, -0.7002> <-1.2689, -0.0789, -0.7326> <-1.2689, -0.0028, -0.7326>
		<-1.0509, -0.2195, -0.8458> <-1.1092, -0.1839, -0.8795> <-1.1551, -0.0789, -0.9297> <-1.1551, -0.0028, -0.9297>
		<-0.8458, -0.2195, -1.0509> <-0.8795, -0.1839, -1.1092> <-0.9297, -0.0789, -1.1551> <-0.9297, -0.0028, -1.1551>
		<-0.6665, -0.2195, -1.1544> <-0.7002, -0.1839, -1.2127> <-0.7326, -0.0789, -1.2689> <-0.7326, -0.0028, -1.2689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6665, -0.2195, -1.1544> <-0.7002, -0.1839, -1.2127> <-0.7326, -0.0789, -1.2689> <-0.7326, -0.0028, -1.2689>
		<-0.4872, -0.2195, -1.2579> <-0.5209, -0.1839, -1.3162> <-0.5356, -0.0789, -1.3827> <-0.5356, -0.0028, -1.3827>
		<-0.2070, -0.2195, -1.3330> <-0.2070, -0.1839, -1.4004> <-0.2275, -0.0789, -1.4652> <-0.2275, -0.0028, -1.4652>
		<0.0000, -0.2195, -1.3330> <0.0000, -0.1839, -1.4004> <0.0000, -0.0789, -1.4652> <0.0000, -0.0028, -1.4652>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2195, -1.3330> <0.0000, -0.1839, -1.4004> <0.0000, -0.0789, -1.4652> <0.0000, -0.0028, -1.4652>
		<0.2070, -0.2195, -1.3330> <0.2070, -0.1839, -1.4004> <0.2275, -0.0789, -1.4652> <0.2275, -0.0028, -1.4652>
		<0.4872, -0.2195, -1.2579> <0.5209, -0.1839, -1.3162> <0.5356, -0.0789, -1.3827> <0.5356, -0.0028, -1.3827>
		<0.6665, -0.2195, -1.1544> <0.7002, -0.1839, -1.2127> <0.7326, -0.0789, -1.2689> <0.7326, -0.0028, -1.2689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6665, -0.2195, -1.1544> <0.7002, -0.1839, -1.2127> <0.7326, -0.0789, -1.2689> <0.7326, -0.0028, -1.2689>
		<0.8458, -0.2195, -1.0509> <0.8795, -0.1839, -1.1092> <0.9297, -0.0789, -1.1551> <0.9297, -0.0028, -1.1551>
		<1.0509, -0.2195, -0.8458> <1.1092, -0.1839, -0.8795> <1.1551, -0.0789, -0.9297> <1.1551, -0.0028, -0.9297>
		<1.1544, -0.2195, -0.6665> <1.2127, -0.1839, -0.7002> <1.2689, -0.0789, -0.7326> <1.2689, -0.0028, -0.7326>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2689, -0.0028, 0.7326> <1.2689, 0.0734, 0.7326> <1.2127, 0.1784, 0.7002> <1.1544, 0.2140, 0.6665>
		<1.1551, -0.0028, 0.9297> <1.1551, 0.0734, 0.9297> <1.1092, 0.1784, 0.8795> <1.0509, 0.2140, 0.8458>
		<0.9297, -0.0028, 1.1551> <0.9297, 0.0734, 1.1551> <0.8795, 0.1784, 1.1092> <0.8458, 0.2140, 1.0509>
		<0.7326, -0.0028, 1.2689> <0.7326, 0.0734, 1.2689> <0.7002, 0.1784, 1.2127> <0.6665, 0.2140, 1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.7326, -0.0028, 1.2689> <0.7326, 0.0734, 1.2689> <0.7002, 0.1784, 1.2127> <0.6665, 0.2140, 1.1544>
		<0.5356, -0.0028, 1.3827> <0.5356, 0.0734, 1.3827> <0.5209, 0.1784, 1.3162> <0.4872, 0.2140, 1.2579>
		<0.2275, -0.0028, 1.4652> <0.2275, 0.0734, 1.4652> <0.2070, 0.1784, 1.4004> <0.2070, 0.2140, 1.3330>
		<-0.0000, -0.0028, 1.4652> <-0.0000, 0.0734, 1.4652> <-0.0000, 0.1784, 1.4004> <-0.0000, 0.2140, 1.3330>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, -0.0028, 1.4652> <-0.0000, 0.0734, 1.4652> <-0.0000, 0.1784, 1.4004> <-0.0000, 0.2140, 1.3330>
		<-0.2275, -0.0028, 1.4652> <-0.2275, 0.0734, 1.4652> <-0.2070, 0.1784, 1.4004> <-0.2070, 0.2140, 1.3330>
		<-0.5356, -0.0028, 1.3827> <-0.5356, 0.0734, 1.3827> <-0.5209, 0.1784, 1.3162> <-0.4872, 0.2140, 1.2579>
		<-0.7326, -0.0028, 1.2689> <-0.7326, 0.0734, 1.2689> <-0.7002, 0.1784, 1.2127> <-0.6665, 0.2140, 1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7326, -0.0028, 1.2689> <-0.7326, 0.0734, 1.2689> <-0.7002, 0.1784, 1.2127> <-0.6665, 0.2140, 1.1544>
		<-0.9297, -0.0028, 1.1551> <-0.9297, 0.0734, 1.1551> <-0.8795, 0.1784, 1.1092> <-0.8458, 0.2140, 1.0509>
		<-1.1551, -0.0028, 0.9297> <-1.1551, 0.0734, 0.9297> <-1.1092, 0.1784, 0.8795> <-1.0509, 0.2140, 0.8458>
		<-1.2689, -0.0028, 0.7326> <-1.2689, 0.0734, 0.7326> <-1.2127, 0.1784, 0.7002> <-1.1544, 0.2140, 0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2689, -0.0028, 0.7326> <-1.2689, 0.0734, 0.7326> <-1.2127, 0.1784, 0.7002> <-1.1544, 0.2140, 0.6665>
		<-1.3827, -0.0028, 0.5356> <-1.3827, 0.0734, 0.5356> <-1.3162, 0.1784, 0.5209> <-1.2579, 0.2140, 0.4872>
		<-1.4652, -0.0028, 0.2275> <-1.4652, 0.0734, 0.2275> <-1.4004, 0.1784, 0.2070> <-1.3330, 0.2140, 0.2070>
		<-1.4652, -0.0028, -0.0000> <-1.4652, 0.0734, -0.0000> <-1.4004, 0.1784, -0.0000> <-1.3330, 0.2140, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4652, -0.0028, -0.0000> <-1.4652, 0.0734, -0.0000> <-1.4004, 0.1784, -0.0000> <-1.3330, 0.2140, -0.0000>
		<-1.4652, -0.0028, -0.2275> <-1.4652, 0.0734, -0.2275> <-1.4004, 0.1784, -0.2070> <-1.3330, 0.2140, -0.2070>
		<-1.3827, -0.0028, -0.5356> <-1.3827, 0.0734, -0.5356> <-1.3162, 0.1784, -0.5209> <-1.2579, 0.2140, -0.4872>
		<-1.2689, -0.0028, -0.7326> <-1.2689, 0.0734, -0.7326> <-1.2127, 0.1784, -0.7002> <-1.1544, 0.2140, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2689, -0.0028, -0.7326> <-1.2689, 0.0734, -0.7326> <-1.2127, 0.1784, -0.7002> <-1.1544, 0.2140, -0.6665>
		<-1.1551, -0.0028, -0.9297> <-1.1551, 0.0734, -0.9297> <-1.1092, 0.1784, -0.8795> <-1.0509, 0.2140, -0.8458>
		<-0.9297, -0.0028, -1.1551> <-0.9297, 0.0734, -1.1551> <-0.8795, 0.1784, -1.1092> <-0.8458, 0.2140, -1.0509>
		<-0.7326, -0.0028, -1.2689> <-0.7326, 0.0734, -1.2689> <-0.7002, 0.1784, -1.2127> <-0.6665, 0.2140, -1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7326, -0.0028, -1.2689> <-0.7326, 0.0734, -1.2689> <-0.7002, 0.1784, -1.2127> <-0.6665, 0.2140, -1.1544>
		<-0.5356, -0.0028, -1.3827> <-0.5356, 0.0734, -1.3827> <-0.5209, 0.1784, -1.3162> <-0.4872, 0.2140, -1.2579>
		<-0.2275, -0.0028, -1.4652> <-0.2275, 0.0734, -1.4652> <-0.2070, 0.1784, -1.4004> <-0.2070, 0.2140, -1.3330>
		<0.0000, -0.0028, -1.4652> <0.0000, 0.0734, -1.4652> <0.0000, 0.1784, -1.4004> <0.0000, 0.2140, -1.3330>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0028, -1.4652> <0.0000, 0.0734, -1.4652> <0.0000, 0.1784, -1.4004> <0.0000, 0.2140, -1.3330>
		<0.2275, -0.0028, -1.4652> <0.2275, 0.0734, -1.4652> <0.2070, 0.1784, -1.4004> <0.2070, 0.2140, -1.3330>
		<0.5356, -0.0028, -1.3827> <0.5356, 0.0734, -1.3827> <0.5209, 0.1784, -1.3162> <0.4872, 0.2140, -1.2579>
		<0.7326, -0.0028, -1.2689> <0.7326, 0.0734, -1.2689> <0.7002, 0.1784, -1.2127> <0.6665, 0.2140, -1.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.7326, -0.0028, -1.2689> <0.7326, 0.0734, -1.2689> <0.7002, 0.1784, -1.2127> <0.6665, 0.2140, -1.1544>
		<0.9297, -0.0028, -1.1551> <0.9297, 0.0734, -1.1551> <0.8795, 0.1784, -1.1092> <0.8458, 0.2140, -1.0509>
		<1.1551, -0.0028, -0.9297> <1.1551, 0.0734, -0.9297> <1.1092, 0.1784, -0.8795> <1.0509, 0.2140, -0.8458>
		<1.2689, -0.0028, -0.7326> <1.2689, 0.0734, -0.7326> <1.2127, 0.1784, -0.7002> <1.1544, 0.2140, -0.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1544, 0.2140, 0.6665> <1.0988, 0.2479, 0.6344> <0.9607, 0.2099, 0.5547> <0.9453, 0.1947, 0.5457>
		<1.0509, 0.2140, 0.8458> <0.9953, 0.2479, 0.8136> <0.8759, 0.2099, 0.7014> <0.8605, 0.1947, 0.6925>
		<0.8458, 0.2140, 1.0509> <0.8136, 0.2479, 0.9953> <0.7014, 0.2099, 0.8759> <0.6925, 0.1947, 0.8605>
		<0.6665, 0.2140, 1.1544> <0.6344, 0.2479, 1.0988> <0.5547, 0.2099, 0.9607> <0.5457, 0.1947, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6665, 0.2140, 1.1544> <0.6344, 0.2479, 1.0988> <0.5547, 0.2099, 0.9607> <0.5457, 0.1947, 0.9453>
		<0.4872, 0.2140, 1.2579> <0.4551, 0.2479, 1.2023> <0.4079, 0.2099, 1.0454> <0.3990, 0.1947, 1.0300>
		<0.2070, 0.2140, 1.3330> <0.2070, 0.2479, 1.2688> <0.1695, 0.2099, 1.1093> <0.1695, 0.1947, 1.0915>
		<-0.0000, 0.2140, 1.3330> <-0.0000, 0.2479, 1.2688> <-0.0000, 0.2099, 1.1093> <-0.0000, 0.1947, 1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0000, 0.2140, 1.3330> <-0.0000, 0.2479, 1.2688> <-0.0000, 0.2099, 1.1093> <-0.0000, 0.1947, 1.0915>
		<-0.2070, 0.2140, 1.3330> <-0.2070, 0.2479, 1.2688> <-0.1695, 0.2099, 1.1093> <-0.1695, 0.1947, 1.0915>
		<-0.4872, 0.2140, 1.2579> <-0.4551, 0.2479, 1.2023> <-0.4079, 0.2099, 1.0454> <-0.3990, 0.1947, 1.0300>
		<-0.6665, 0.2140, 1.1544> <-0.6344, 0.2479, 1.0988> <-0.5547, 0.2099, 0.9607> <-0.5457, 0.1947, 0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6665, 0.2140, 1.1544> <-0.6344, 0.2479, 1.0988> <-0.5547, 0.2099, 0.9607> <-0.5457, 0.1947, 0.9453>
		<-0.8458, 0.2140, 1.0509> <-0.8136, 0.2479, 0.9953> <-0.7014, 0.2099, 0.8759> <-0.6925, 0.1947, 0.8605>
		<-1.0509, 0.2140, 0.8458> <-0.9953, 0.2479, 0.8136> <-0.8759, 0.2099, 0.7014> <-0.8605, 0.1947, 0.6925>
		<-1.1544, 0.2140, 0.6665> <-1.0988, 0.2479, 0.6344> <-0.9607, 0.2099, 0.5547> <-0.9453, 0.1947, 0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1544, 0.2140, 0.6665> <-1.0988, 0.2479, 0.6344> <-0.9607, 0.2099, 0.5547> <-0.9453, 0.1947, 0.5457>
		<-1.2579, 0.2140, 0.4872> <-1.2023, 0.2479, 0.4551> <-1.0454, 0.2099, 0.4079> <-1.0300, 0.1947, 0.3990>
		<-1.3330, 0.2140, 0.2070> <-1.2688, 0.2479, 0.2070> <-1.1093, 0.2099, 0.1695> <-1.0915, 0.1947, 0.1695>
		<-1.3330, 0.2140, -0.0000> <-1.2688, 0.2479, -0.0000> <-1.1093, 0.2099, -0.0000> <-1.0915, 0.1947, -0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3330, 0.2140, -0.0000> <-1.2688, 0.2479, -0.0000> <-1.1093, 0.2099, -0.0000> <-1.0915, 0.1947, -0.0000>
		<-1.3330, 0.2140, -0.2070> <-1.2688, 0.2479, -0.2070> <-1.1093, 0.2099, -0.1695> <-1.0915, 0.1947, -0.1695>
		<-1.2579, 0.2140, -0.4872> <-1.2023, 0.2479, -0.4551> <-1.0454, 0.2099, -0.4079> <-1.0300, 0.1947, -0.3990>
		<-1.1544, 0.2140, -0.6665> <-1.0988, 0.2479, -0.6344> <-0.9607, 0.2099, -0.5547> <-0.9453, 0.1947, -0.5457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1544, 0.2140, -0.6665> <-1.0988, 0.2479, -0.6344> <-0.9607, 0.2099, -0.5547> <-0.9453, 0.1947, -0.5457>
		<-1.0509, 0.2140, -0.8458> <-0.9953, 0.2479, -0.8136> <-0.8759, 0.2099, -0.7014> <-0.8605, 0.1947, -0.6925>
		<-0.8458, 0.2140, -1.0509> <-0.8136, 0.2479, -0.9953> <-0.7014, 0.2099, -0.8759> <-0.6925, 0.1947, -0.8605>
		<-0.6665, 0.2140, -1.1544> <-0.6344, 0.2479, -1.0988> <-0.5547, 0.2099, -0.9607> <-0.5457, 0.1947, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6665, 0.2140, -1.1544> <-0.6344, 0.2479, -1.0988> <-0.5547, 0.2099, -0.9607> <-0.5457, 0.1947, -0.9453>
		<-0.4872, 0.2140, -1.2579> <-0.4551, 0.2479, -1.2023> <-0.4079, 0.2099, -1.0454> <-0.3990, 0.1947, -1.0300>
		<-0.2070, 0.2140, -1.3330> <-0.2070, 0.2479, -1.2688> <-0.1695, 0.2099, -1.1093> <-0.1695, 0.1947, -1.0915>
		<0.0000, 0.2140, -1.3330> <0.0000, 0.2479, -1.2688> <0.0000, 0.2099, -1.1093> <0.0000, 0.1947, -1.0915>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2140, -1.3330> <0.0000, 0.2479, -1.2688> <0.0000, 0.2099, -1.1093> <0.0000, 0.1947, -1.0915>
		<0.2070, 0.2140, -1.3330> <0.2070, 0.2479, -1.2688> <0.1695, 0.2099, -1.1093> <0.1695, 0.1947, -1.0915>
		<0.4872, 0.2140, -1.2579> <0.4551, 0.2479, -1.2023> <0.4079, 0.2099, -1.0454> <0.3990, 0.1947, -1.0300>
		<0.6665, 0.2140, -1.1544> <0.6344, 0.2479, -1.0988> <0.5547, 0.2099, -0.9607> <0.5457, 0.1947, -0.9453>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6665, 0.2140, -1.1544> <0.6344, 0.2479, -1.0988> <0.5547, 0.2099, -0.9607> <0.5457, 0.1947, -0.9453>
		<0.8458, 0.2140, -1.0509> <0.8136, 0.2479, -0.9953> <0.7014, 0.2099, -0.8759> <0.6925, 0.1947, -0.8605>
		<1.0509, 0.2140, -0.8458> <0.9953, 0.2479, -0.8136> <0.8759, 0.2099, -0.7014> <0.8605, 0.1947, -0.6925>
		<1.1544, 0.2140, -0.6665> <1.0988, 0.2479, -0.6344> <0.9607, 0.2099, -0.5547> <0.9453, 0.1947, -0.5457>
	}
    texture { T_Dunlop }
}


#declare Eksoteriko_Zantas = difference {
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <1.085, 1.085, 0.25>
    rotate -90.0*x
    translate  -0.125*y
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <1.01, 1.01, 0.3>
    rotate -90.0*x
    translate  -0.15*y
  }
  texture { T_ZantesStuff }
}

#declare V8_wheel = union {
  object { Wheel_Pelma }
  object { Eksoteriko_Zantas }
  object { Aktines }
  object { Kentro }
}
